
#ifndef _DXDRAW_
#define _DXDRAW_

#include <windows.h>
#include <ddraw.h>
#include <mmsystem.h>


#define MAX_SURFACE_RESTORE_ATTEMPTS	3

//Error codes
#define EC_FAILED_TO_LOAD_DIRECTDRAW_LIBRARY				-1
#define EC_FAILED_TO_GET_DIRECTDRAWCREATE_PROCEDURE_ADDRESS	-2
#define EC_DIRECTDRAWCREATE_FAILED							-3
#define EC_SETCOOPERATIVELEVEL_FAILED						-4
#define EC_COULD_NOT_CREATE_OVERLAY_SURFACE					-5
#define EC_COULD_NOT_CREATE_PRIMARY_SURFACE					-6
#define EC_COULD_NOT_SHOW_OVERLAY							-7
#define EC_COULD_NOT_GET_BACK_BUFFER						-8
#define EC_COULD_NOT_LOCK_SURFACE							-9
#define EC_COULD_NOT_MOVE_OVERLAY							-10
#define EC_COULD_NOT_CALCULATE_COLOR_KEY					-11
#define EC_COULD_NOT_GET_DIRECTDRAW_CAPS					-12
#define EC_NO_OVERLAY_CAPS_DETECTED							-13
#define EC_MINIMUM_OVERLAY_STRETCH_FACTOR_TOO_LARGE			-14
#define EC_COULD_NOT_CREATE_OFF_SCREEN_SURFACE				-15
#define EC_COULD_NOT_GET_CLIENT_RECT						-16
#define EC_COULD_NOT_CREATE_CLIPPER							-17
#define EC_COULD_NOT_SET_CLIPPING_WINDOW					-18
#define EC_COULD_NOT_ATTACH_CLIPPER							-19
#define EC_SURFACE_DOES_NOT_EXIST							-20
#define EC_BLT_FAILED										-21

//Overlay flags
#define OVERLAY_ENABLE_COLOR_KEY_CLIPPING	1
#define OVERLAY_ENABLE_WINDOW_CLIPPING		2
#define OVERLAY_ENABLE_ALPHA_BLENDING		4

#ifndef NO_DXDRAW_FUNCTION_PROTOTYPES
extern LONG InitializeDirectDraw(VOID);
extern VOID DestroyDirectDraw(VOID);
extern VOID UnloadDirectDraw(VOID);
extern LONG SetNormalCooperativeLevel(HWND);
extern LONG CheckOverlayCaps(DWORD, DWORD, DWORD *, DWORD *);
extern LONG CreateOverlay(DWORD, DWORD, BOOL, DWORD, BOOL, FOURCC, DWORD, HWND);
extern VOID FreeOverlay(VOID);
extern LONG FlipOverlay(VOID);
extern LONG LockOverlay(LPVOID *, DWORD *);
extern LONG UnlockOverlay(VOID);
extern LONG MoveOverlay(LONG, LONG);
extern LONG ShowOverlay(LONG, LONG, DWORD, COLORREF);
extern LONG HideOverlay(VOID);
extern LONG GetOverlayWidth(VOID);
extern LONG GetOverlayHeight(VOID);
extern HRESULT GetDxDrawErrorCode(VOID);
extern VOID SetDxDrawErrorCode(HRESULT);

extern LONG CreateOffScreenSurface(DWORD, DWORD, BOOL, DWORD, BOOL, FOURCC, HWND);
extern VOID FreeOffScreenSurface(VOID);
extern LONG FlipOffScreenSurface(VOID);
extern LONG LockOffScreenSurface(LPVOID *, DWORD *);
extern LONG UnlockOffScreenSurface(VOID);
#endif

#endif //_DXDRAW_
